﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_WAVE_FILE_READER_H_
#define NW_SND_WAVE_FILE_READER_H_

#include <nw/snd/snd_WaveFile.h>
#include <nw/snd/snd_DspadpcmReader.h>

namespace nw {
namespace snd {
namespace internal {

class WaveFileReader
{
public:
    static const u32 SIGNATURE_FILE = NW_UT_MAKE_SIGWORD( 'F', 'W', 'A', 'V' );
    static SampleFormat GetSampleFormat( u8 encodeMethod );

    WaveFileReader( const void* waveFile, s8 waveType = WAVE_TYPE_NWWAV );

    bool IsOriginalLoopAvailable() const;

    bool ReadWaveInfo( WaveInfo* info, const void* waveDataOffsetOrigin = NULL ) const;

    struct OffsetContextInfo
    {
        u32 offsetSample;
        AdpcmContext contexts[WAVE_CHANNEL_MAX];

        OffsetContextInfo() : offsetSample(0) {}
    };
    bool CalcOffsetContextInfo(u32 offsetSample, OffsetContextInfo* info) const;
private:
    const void* GetWaveDataAddress(
            const WaveFile::ChannelInfo* info,
            const void* waveDataOffsetOrigin ) const;

    const WaveFile::FileHeader*     m_pHeader;
    const WaveFile::InfoBlockBody*  m_pInfoBlockBody;
    const void*                     m_pDataBlockBody;

    DspadpcmReader m_DspadpcmReader;
    s8 m_WaveType;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_WAVE_FILE_READER_H_ */

