﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_TASK_THREAD_H_
#define NW_SND_TASK_THREAD_H_

#include <nw/snd/snd_ThreadStack.h>
#include <nw/snd/snd_Util.h>
#include <nw/ut.h>

namespace nw {
namespace snd {
namespace internal {

class TaskThread : public nw::ut::ThreadHandler
{
public:
    TaskThread();
    virtual ~TaskThread();

    bool Create( s32 priority, void* stackBase, u32 stackSize, u32 affinityMask );
    void Destroy();

    bool IsCreated() const { return m_IsCreated != 0; }

    void Lock()
    {
        m_CriticalSection.Enter();
    }
    void Unlock()
    {
        m_CriticalSection.Leave();
    }
    static TaskThread& GetInstance();

protected:
    virtual void ThreadHandlerProc();

private:
    nw::ut::Thread          m_Thread;
    nw::ut::CriticalSection m_CriticalSection;
    volatile bool m_IsFinished;
    bool m_IsCreated;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_TASK_THREAD_H_ */

