﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_PLAYER_HEAP_DATA_MANAGER_H_
#define NW_SND_PLAYER_HEAP_DATA_MANAGER_H_

#include <nw/snd/snd_DisposeCallback.h>
#include <nw/snd/snd_SoundArchiveLoader.h>
#include <nw/snd/snd_SoundArchive.h>

namespace nw {
namespace snd {
namespace internal {

class PlayerHeapDataManager : public internal::driver::DisposeCallback,
                              public internal::SoundArchiveLoader
{
public:
    PlayerHeapDataManager();
    virtual ~PlayerHeapDataManager();

    void Initialize( const SoundArchive* arc );
    void Finalize();

    const void* SetFileAddress( SoundArchive::FileId fileId, const void* address );
    const void* GetFileAddress( SoundArchive::FileId ) const;

    static const int FILE_ADDRESS_COUNT = 1 + 4 + 4;

protected:
    virtual void InvalidateData( const void* start, const void* end );
    virtual const void* SetFileAddressToTable(
            SoundArchive::FileId, const void* address );
    virtual const void* GetFileAddressFromTable( SoundArchive::FileId fileId ) const;
    virtual const void* GetFileAddressImpl( SoundArchive::FileId fileId ) const;

private:
    struct FileAddress
    {
        SoundArchive::FileId fileId;
        const void* address;
    };

    FileAddress m_FileAddress[FILE_ADDRESS_COUNT];
        // NW4F-1.9.0 現在、ひとつのサウンドを鳴らすのに必要なファイルは、最大９個
        // (== bfseq + 4 * bfbnk + 4 * bfwar)。
    bool m_IsInitialized;
    bool m_IsFinalized;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_PLAYER_HEAP_DATA_MANAGER_H_ */

