﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_NOTE_ON_CALLBACK_H_
#define NW_SND_NOTE_ON_CALLBACK_H_

#include <nw/snd/snd_Channel.h>     // Channel::ChannelCallback

namespace nw {
namespace snd {
namespace internal {
namespace driver {

class SequenceSoundPlayer;

struct NoteOnInfo
{
    int prgNo;
    int key;
    int velocity;
    int length;
    int initPan;
    int priority;
    Channel::ChannelCallback channelCallback;
    void* channelCallbackData;
    VoiceRendererType rendererType;
};

class NoteOnCallback
{
public:
    virtual ~NoteOnCallback() {}

    virtual Channel* NoteOn(
        SequenceSoundPlayer* sequenceSoundPlayer,
        u8 bankIndex,
        const NoteOnInfo& noteOnInfo
    ) = 0;
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_NOTE_ON_CALLBACK_H_ */

