﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_MULTI_VOICE_MANAGER_H_
#define NW_SND_MULTI_VOICE_MANAGER_H_

#include <nw/snd/snd_MultiVoice.h>
#include <nw/ut/ut_LinkList.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

/* ========================================================================
        class definition
   ======================================================================== */

class MultiVoiceManager
{
    friend class MultiVoice;

public:
    typedef ut::LinkList< MultiVoice, offsetof(MultiVoice,m_LinkNode)> VoiceList;

public:
    static MultiVoiceManager& GetInstance();

    size_t GetRequiredMemSize( int voiceCount );
    void Initialize( void* mem, size_t memSize );
    void Finalize();

    // ------------------------------------------------------------------------
    // ボイス管理
    MultiVoice* AllocVoice(
        int voiceChannelCount,
        int priority,
        MultiVoice::VoiceCallback callback,
        void* callbackData,
        VoiceRendererType rendererType = VOICE_RENDERER_SDK
    );
    void FreeVoice( MultiVoice* voice );

    void StopAllVoices();

    void UpdateAllVoices();
    void UpdateAllVoiceStatus();
    void UpdateAllVoicesSync( u32 syncFlag );

    int GetVoiceCount() const;
    unsigned long GetActiveCount() const;
    unsigned long GetFreeCount() const;
    const VoiceList& GetVoiceList() const;

private:
    MultiVoiceManager();

    void ChangeVoicePriority( MultiVoice* voice );
    int DropLowestPriorityVoice( int priority );
    void UpdateEachVoicePriority(
        const VoiceList::Iterator& beginItr,
        const VoiceList::Iterator& endItr
    );

    void AppendVoiceList( MultiVoice* voice );
    void RemoveVoiceList( MultiVoice* voice );

    bool m_Initialized;
    VoiceList m_PrioVoiceList; // lower priority order
    VoiceList m_FreeVoiceList;
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_MULTI_VOICE_MANAGER_H_ */

