﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_BANK_H_
#define NW_SND_BANK_H_

#include <nw/snd/snd_NoteOnCallback.h>      // NoteOnInfo
#include <nw/snd/snd_Channel.h>
#include <nw/snd/snd_PlayerHeapDataManager.h>

namespace nw {
namespace snd {

class SoundArchive;
class SoundArchivePlayer;

namespace internal {

class BankFileReader;
class WaveArchiveFileReader;

namespace driver {

/* ========================================================================
        class definition
   ======================================================================== */

class Bank
{
public:
    /* ------------------------------------------------------------------------
            class members
       ------------------------------------------------------------------------ */
    Bank();
    ~Bank();

    Channel* NoteOn(
        const BankFileReader& bankReader,
        const WaveArchiveFileReader& warcReader,
        const NoteOnInfo& noteOnInfo
    ) const;

    static f32 CalcChannelVelocityVolume(u8 velocity);
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_BANK_H_ */

