﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_RESOURCE_ALLOCATOR_H_
#define NW_SND_EDIT_RESOURCE_ALLOCATOR_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/fnd/basis/sndfnd_Memory.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  リソースサイズに応じてヒープの割り当て先（前後）を切り替えるアロケータです。
//---------------------------------------------------------------------------
class ResourceAllocator : public snd::internal::fnd::IAllocator
{
public:
    ResourceAllocator() : m_ThresholdSize(0), m_SourceAllocator(NULL) { }
    virtual ~ResourceAllocator() { }

public:
    void Initialize(snd::internal::fnd::IAllocator* allocator, size_t thresholdSize)
    {
        NW_ASSERT_NOT_NULL(allocator);
        m_ThresholdSize = thresholdSize;
        m_SourceAllocator = allocator;
    }

    void Finalize()
    {
        m_ThresholdSize = 0;
        m_SourceAllocator = NULL;
    }

    virtual void* Alloc(size_t size, s32 alignment = snd::internal::fnd::MemoryTraits::DEFAULT_ALIGNMENT)
    {
        NW_ASSERT_NOT_NULL(m_SourceAllocator);
        return m_SourceAllocator->Alloc(
            size,
            m_ThresholdSize < size ? alignment : -alignment);
    }

    virtual void Free(void* ptr)
    {
        NW_ASSERT_NOT_NULL(m_SourceAllocator);
        return m_SourceAllocator->Free(ptr);
    }

private:
    size_t                          m_ThresholdSize;
    snd::internal::fnd::IAllocator* m_SourceAllocator;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_RESOURCE_ALLOCATOR_H_
