﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_SYNC_PACKET_H_
#define NW_SND_EDIT_SYNC_PACKET_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/res/sndedit_ResTypes.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  実機から定期的に送信される同期パケットです。
//---------------------------------------------------------------------------
class SyncPacket : public HioPacket
{
public:
    class Body : public HioPacketBody
    {
    public:
        Body() :
          version(HIO_PROTOCOL_VERSION),
          m_MemoryMax(0),
          m_MemoryUsage(0),
          m_MaxEditableItemCount(0),
          m_EditItemCount(0),
          m_MaxEditableFileCount(0),
          m_EditFileCount(0),
          m_IsOutOfMemory(false),
          m_IsItemsOverflow(false),
          m_IsFilesOverflow(false),
          padding0(0),
          interim_isSoundPlayer(false),
          padding1(0),
          padding2(0) { }

        u32 GetMemoryMax() const { return m_MemoryMax; }
        void SetMemoryMax(u32 value) { m_MemoryMax = value; }

        u32 GetMemoryUsage() const { return m_MemoryUsage; }
        void SetMemoryUsage(u32 value) { m_MemoryUsage = value; }

        u32 GetMaxEditableItemCount() const { return m_MaxEditableItemCount; }
        void SetMaxEditableItemCount(u32 value) { m_MaxEditableItemCount = value; }

        u32 GetEditItemCount() const { return m_EditItemCount; }
        void SetEditItemCount(u32 value) { m_EditItemCount = value; }

        u32 GetMaxEditableFileCount() const { return m_MaxEditableFileCount; }
        void SetMaxEditableFileCount(u32 value) { m_MaxEditableFileCount = value; }

        u32 GetEditFileCount() const { return m_EditFileCount; }
        void SetEditFileCount(u32 value) { m_EditFileCount = value; }

        bool GetIsOutOfMemory() const { return m_IsOutOfMemory; }
        void SetIsOutOfMemory(bool value) { m_IsOutOfMemory = value; }

        bool GetIsItemsOverflow() const { return m_IsItemsOverflow; }
        void SetIsItemsOverflow(bool value) { m_IsItemsOverflow = value; }

        bool GetIsFilesOverflow() const { return m_IsFilesOverflow; }
        void SetIsFilesOverflow(bool value) { m_IsFilesOverflow = value; }

// HACK : ★SoundMaker がゲームアプリと SoundPlayer の区別がつくようになるまでの暫定コード
#if 1
        void Interim_SetIsSoundPlayer(bool value)
        {
            interim_isSoundPlayer = value;
        }
#endif

    private:
        ResVersion                  version;                 //!< バージョン情報です。
        snd::internal::fnd::BinU32  m_MemoryMax;             //!< メモリの上限値（バイト）です。
        snd::internal::fnd::BinU32  m_MemoryUsage;           //!< メモリ使用量（バイト）です。
        snd::internal::fnd::BinU32  m_MaxEditableItemCount;  //!< 差し替え可能なアイテムの最大数です。
        snd::internal::fnd::BinU32  m_EditItemCount;         //!< 現在差し替え中のアイテム数です。
        snd::internal::fnd::BinU32  m_MaxEditableFileCount;  //!< 差し替え可能なファイルの最大数です。
        snd::internal::fnd::BinU32  m_EditFileCount;         //!< 現在差し替え中の現在のファイル数です。
        snd::internal::fnd::BinBool m_IsOutOfMemory;         //!< メモリ不足フラグです。
        snd::internal::fnd::BinBool m_IsItemsOverflow;       //!< アイテム数のオーバーフローフラグです。
        snd::internal::fnd::BinBool m_IsFilesOverflow;       //!< ファイル数のオーバーフローフラグです。
        u8                          padding0;

// HACK : ★SoundMaker がゲームアプリと SoundPlayer の区別がつくようになるまでの暫定コード
#if 1
        snd::internal::fnd::BinBool interim_isSoundPlayer;
        u8                          padding1;
        u16                         padding2;
#endif
    };

public:
    SyncPacket() : HioPacket(HIO_MESSAGE_SYNC, 0)
    {
    }

// HACK : ★SoundMaker がゲームアプリと SoundPlayer の区別がつくようになるまでの暫定コード
#if 1
    explicit SyncPacket(bool interim_isSoundPlayer) : HioPacket(HIO_MESSAGE_SYNC_REPLY, sizeof(Body))
    {
        m_Body.Interim_SetIsSoundPlayer(interim_isSoundPlayer);
    }
#endif

public:
    static u32 GetRequiredSize()
    {
        return sizeof(SyncPacket);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

//---------------------------------------------------------------------------
//! @brief  SyncPacket の返信パケットです。
//---------------------------------------------------------------------------
class SyncReplyPacket : public HioPacket
{
public:
    struct Body : public HioPacketBody
    {
        Body() : isAccepted(false) { }

        snd::internal::fnd::BinBool isAccepted;
        u8                          padding[3];
    };

public:
    SyncReplyPacket() : HioPacket(HIO_MESSAGE_SYNC_REPLY, sizeof(Body))
    {
    }

public:
    static u32 GetRequiredSize()
    {
        return sizeof(SyncReplyPacket);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_SYNC_PACKET_H_
