﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_HIO_SYNC_CHANNEL_H_
#define NW_SND_EDIT_HIO_SYNC_CHANNEL_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioChannel.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

class HioManager;

//---------------------------------------------------------------------------
//! @brief    HIO同期チャンネルを示すクラスです。
//---------------------------------------------------------------------------
class HioSyncChannel : public HioChannel
{
public:
    static const u32 TIMEOUT_INFINITY;

public:
    /* ctor */ HioSyncChannel() { }
    /* dtor */ virtual ~HioSyncChannel() { }

public:
    //! @brief  非同期チャンネルかどうかを取得します。
    //! @return TBD
    virtual bool IsAsync() const { return false; }

    //! @brief  HIO パケットを同期送信します。
    //! @param replyPacket TBD
    //! @param message TBD
    //! @param timeout TBD
    //! @return TBD
    HioResult Send(const HioPacket*& replyPacket, const HioPacket& message, u32 timeout = TIMEOUT_INFINITY);

    //! @brief  HIO パケットの受信します。
    //! @param packet TBD
    //! @param timeout TBD
    //! @return TBD
    HioResult Receive(const HioPacket*& packet, u32 timeout = TIMEOUT_INFINITY);
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_HIO_SYNC_CHANNEL_H_
