﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_QUERY_ITEMS_REPLY_HANDLER_H_
#define NW_SND_EDIT_QUERY_ITEMS_REPLY_HANDLER_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/hio/sndedit_HioMessageHandler.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

class HioPacketStream;
class SoundEditConnection;

class QueryItemsReplyHandler : public HioMessageHandler
{
public:
    QueryItemsReplyHandler();
    virtual ~QueryItemsReplyHandler() { }

public:
    void Initialize(SoundEditConnection& connection, u32 maxItemName);
    void Finalize();

protected:
    //---------------------------------------------------------------------------
    //! @brief         処理対象のHIOメッセージを取得します。
    //!
    //! @return        処理対象のHIOメッセージを返します。
    //---------------------------------------------------------------------------
    virtual HioMessageType GetTargetMessage() const { return HIO_MESSAGE_QUERY_ITEMS_REPLY; }

    //---------------------------------------------------------------------------
    //! @brief         HIOメッセージを処理します。
    //!
    //! @details       パケットを逐次読み込みながら処理する場合は、このメソッドをオーバーライドします。
    //!
    //! @param[in]     stream  パケット送受信用のストリームを指定します。
    //!
    //! @return        HIOメッセージの処理結果を返します。
    //---------------------------------------------------------------------------
    virtual HioResult OnInvoke(HioPacketStream& stream);

private:
    HioResult ReadBodyFixedLengthArea(HioPacketStream& stream);
    HioResult ReadItemsOffsets(ResOffsetTableData& items, HioPacketStream& stream);

    u32 ReadItemLength(
        HioPacketStream& stream,
        ResOffsetTableData& itemsData,
        u32 index);

private:
    SoundEditConnection* m_Connection;
    u32                  m_ItemSize;
    u32                  m_ReadingItemIndex;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_QUERY_ITEMS_REPLY_HANDLER_H_
