﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_VOICES_PANEL_H_
#define NW_SND_DW_VOICES_PANEL_H_

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_Separator.h>
#include <nw/snd/dw/control/snddw_PeakMeter.h>
#include <nw/snd/dw/control/snddw_FixedLabelVoiceCountPeakMeter.h>
#include <nw/snd.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class VoicesPanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_VOICE_COUNT = nw::snd::SoundSystem::MAX_VOICE_COUNT;

public:
    VoicesPanel();

protected:
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<3> m_Container;
    nw::internal::dw::FixedStackPanel<MAX_VOICE_COUNT> m_PeakMeterContainer;

    internal::PeakMeter m_VoiceMeters[MAX_VOICE_COUNT];
    internal::FixedLabelVoiceCountPeakMeter m_VoiceCountMeter;
    nw::internal::dw::Separator m_Separator;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "VoicesPanel";
    }
#endif
};

} // dw
} // snd
} // nw

#endif // NW_SND_DW_VOICES_PANEL_H_
