﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_MASTER_OUTPUT_WINDOW_H_
#define NW_SND_DW_MASTER_OUTPUT_WINDOW_H_

#include <nw/snd/dw/snddw_SoundWindow.h>
#include <nw/snd/dw/snddw_MasterOutputPanel.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  サウンドの波形出力を確認するためのデバッグウィンドウです。
//!
//!         このウィンドウでは、以下の操作を行うことができます。
//!
//!         - 波形の表示スケールの変更      : (修飾キー) + ← or →
//!         - 波形の一時停止                : (修飾キー) + HOME
//!
//!         デフォルトの修飾キーは R です。
//!
//! @see SoundWindowSystem クラス
//! @see SoundWindowSystem::SetModifierKey
//! @see SoundWindowSystem::GetModifierKey
//!
//! @date 2012/03/09 キー操作に関する説明を修正
//! @date 2012/02/15 初版
//---------------------------------------------------------------------------
class MasterOutputWindow : public SoundWindow
{
    //! @name コンストラクタ/デストラクタ
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    コンストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    MasterOutputWindow();

    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    ~MasterOutputWindow();
    //@}

    //! @name モニタリング
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    波形のモニタリングを開始します。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    void StartMonitoring();

    //---------------------------------------------------------------------------
    //! @brief    波形のモニタリングを停止します。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    void StopMonitoring();
    //@}

    //! @name 取得/設定
    //@{
    //---------------------------------------------------------------------------
    //! @brief    MasterOutputWindow を１つ作るために必要なメモリを取得します。
    //!
    //! @return 必要とするメモリです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    virtual u32 GetRequiredSize() const;
    //@}

protected:
    //! @briefprivate
    void OnInitialize();

    //! @briefprivate
    void OnFinalize();

private:
    nw::snd::dw::MasterOutputPanel m_Panel;

    void* m_MemoryForPanel;
};

} // namespace dw
} // namespace snd
} // namespace nw

#endif // NW_SDW_MASTER_OUTPUT_WINDOW_H_
