﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MCS_HIONEGOTIATE_H_
#define NW_MCS_HIONEGOTIATE_H_

#if (defined(_MSC_VER) && _MSC_VER > 1000) || defined(__CWCC__)
#pragma once
#endif

#include <nw/types.h>

namespace nw
{
namespace mcs
{
namespace internal
{

class HioNegotiate
{
public:
    static const u32    RebootCode          = 0x1FFFFFFF & ('M' << 24 | 'C' << 16 | 'S' << 8 | '0');
    static const u32    InitBufferCode      = 0x1FFFFFFF & ('I' << 24 | 'N' << 16 | 'B' << 8 | 'F');
    static const u32    AckCode             = 0x1FFFFFFF & ('A' << 24 | 'C' << 16 | 'K' << 8 | 'N');
    static const u32    Disconnect          = 0x1FFFFFFF & ('D' << 24 | 'I' << 16 | 'S' << 8 | 'C');
};

}   // namespace internal
}   // namespace mcs
}   // namespace nw

/* NW_MCS_HIONEGOTIATE_H_ */
#endif
