﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_GFND_TEXTURE_H_
#define NW_GFND_TEXTURE_H_

#include <nw/ut/ut_RuntimeTypeInfo.h>

namespace nw
{
namespace gfnd
{

//---------------------------------------------------------------------------
//! @brief        テクスチャを表す抽象クラスです。
//---------------------------------------------------------------------------
class Texture
{
public:
    NW_UT_RUNTIME_TYPEINFO_ROOT()

    //! @brief コンストラクタです。
    Texture() {}

    //! @brief デストラクタです。
    virtual ~Texture() {}

    //! @brief 幅を取得します。
    //!
    //! @return 幅の値を返します。
    virtual u32 GetWidth() const = 0;

    //! @brief 高さ取得します。
    //!
    //! @return 高さの値を返します。
    virtual u32 GetHeight() const = 0;
};

} // namespace nw::gfnd
} // namespace nw

#endif // NW_GFND_TEXTURE_H_
