﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_RES_RESUTILITY_H_
#define NW_G3D_RES_RESUTILITY_H_

#include <nw/g3d/g3d_config.h>
#include <nw/g3d/res/g3d_ResCommon.h>
#include <nw/g3d/res/g3d_ResDictionary.h>

namespace nw { namespace g3d { namespace math {

class Vec3;
class Vec4;
class Quat;
class Mtx34;

}}}

namespace nw { namespace g3d { namespace fnd { namespace detail {

struct GX2LoopVarData;
struct GX2VertexShaderData;
struct GX2GeometryShaderData;
struct GX2PixelShaderData;
struct GX2ComputeShaderData;

}}}}

namespace nw { namespace g3d { namespace res {

struct ResFileData;
struct ResExternalFileData;
struct ResModelData;
struct ResTextureData;
struct ResSkeletalAnimData;
struct ResBoneAnimData;
struct ResTexPatternAnimData;
struct ResTexPatternMatAnimData;
struct ResShaderParamAnimData;
struct ResShaderParamMatAnimData;
struct ResVisibilityAnimData;
struct ResAnimConstantData;
struct ResAnimBindInfoData;
struct ResAnimCurveData;
struct ResRenderInfoData;
struct ResSkeletonData;
struct ResBoneData;
struct ResVertexData;
struct ResVtxAttribData;
struct ResBufferData;
struct ResShapeData;
struct ResMeshData;
struct ResSubMeshData;
struct ResKeyShapeData;
struct ResMaterialData;
struct ResShaderAssignData;
struct ResRenderStateData;
struct ResTextureRefData;
struct ResSamplerData;
struct ResShaderParamData;
struct ResUserDataData;
struct ResDicPatriciaData;
struct ResShaderArchiveData;
struct ResShadingModelData;
struct ResShaderOptionData;
struct ResAttribVarData;
struct ResSamplerVarData;
struct ResUniformBlockVarData;
struct ResUniformVarData;
struct ResShaderProgramData;
struct ResShapeAnimData;
struct ResVertexShapeAnimData;
struct ResSceneAnimData;
struct ResCameraAnimData;
struct ResLightAnimData;
struct ResFogAnimData;
struct ResOfflineDLShaderData;
struct Bounding;

//! @brief エンディアン反転を行うクラスです。
//!
//! @tparam isReversed 入力ファイルのエンディアンが反転している場合に true とします。
//!
template<bool isReversed>
class Endian
{
public:
    //! @brief データのエンディアンを反転します。
    static void Swap(ResFileData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderArchiveData* data);

private:
    //! @brief データのエンディアンを反転します。
    static void Swap(ResExternalFileData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResModelData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResTextureData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSkeletalAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResBoneAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResTexPatternAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResTexPatternMatAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderParamAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderParamMatAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResVisibilityAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResAnimConstantData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResAnimCurveData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSkeletonData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResBoneData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResVertexData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShapeData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResMeshData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSubMeshData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResKeyShapeData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResBufferData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderAssignData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResMaterialData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResRenderInfoData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResRenderStateData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResTextureRefData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSamplerData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderParamData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResUserDataData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResVtxAttribData* vtxAttribData, ResBufferData* vtxBufferData);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResVtxAttribData*) { /* dummy */ }

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::res::Bounding* data);

    //! @brief データのエンディアンを反転します。
    template<class T>
    static void Swap(ResDicPatriciaData* data, bool isContextSwap);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShadingModelData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderOptionData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResAttribVarData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSamplerVarData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResUniformBlockVarData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResUniformVarData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShaderProgramData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResShapeAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResVertexShapeAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResSceneAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResCameraAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResLightAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResFogAnimData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::fnd::detail::GX2LoopVarData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(ResOfflineDLShaderData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::fnd::detail::GX2VertexShaderData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::fnd::detail::GX2GeometryShaderData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::fnd::detail::GX2PixelShaderData* data);

    //! @brief データのエンディアンを反転します。
    static void Swap(nw::g3d::fnd::detail::GX2ComputeShaderData* data);

    static void Swap(void* data, int typeSize, int elemCount)
    {
        if (typeSize == 4)
        {
            for (u32* pData = static_cast<u32*>(data), *pEnd = pData + elemCount;
                pData != pEnd; ++pData)
            {
                StoreRevU32(pData, *pData);
            }
        }
        else if (typeSize == 2)
        {
            for (u16* pData = static_cast<u16*>(data), *pEnd = pData + elemCount;
                pData != pEnd; ++pData)
            {
                StoreRevU16(pData, *pData);
            }
        }
        else if (typeSize != 1)
        {
            NW_G3D_NOT_SUPPORTED();
        }
    }

    static void Swap(bool*) {}

    static void Swap(s8*) {}

    static void Swap(bit8*) {}

    static void Swap(s16* data)
    {
        Swap(reinterpret_cast<bit16*>(data));
    }

    static void Swap(bit16* data)
    {
        StoreRevU16(data, *data);
    }

    static void Swap(s32* data)
    {
        union
        {
            s32* s32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }

    static void Swap(f32* data)
    {
        union
        {
            f32* f32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }

    static void Swap(bit32* data)
    {
        StoreRevU32(data, *data);
    }

    static void Swap(Vec3* data);
    static void Swap(Vec4* data);
    static void Swap(Quat* data);
    static void Swap(Mtx34* data);

    static void Swap(BinString* data)
    {
        Swap(&data->offset);
    }

    static void Swap(Offset* data)
    {
        s32 offset = *data;
        Swap(&offset);
        *data = offset;
    }

    static void Swap(BinPtr* data)
    {
        Swap(&data->addr);
    }

    template<class T>
    static void SwapArray(Offset* data, int size)
    {
        for (int i = 0; i < size; ++i)
        {
            Swap(&data->to_ptr<T>()[i]);
        }
    }

    template<class T>
    static void SwapDic(Offset* data, bool isContextSwap = true)
    {
        if (data->to_ptr() != NULL)
        {
            Swap<T>(ResDicType::ResCast(data->to_ptr<ResDicType::DataType>())->ptr(), isContextSwap);
        }
    }
};

}}} // namespace nw::g3d::res

#endif // NW_G3D_RES_RESUTILITY_H_
