﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_FND_WINUTILITY_H_
#define NW_G3D_FND_WINUTILITY_H_

// このヘッダは windows.h をインクルードしているため、ライブラリのヘッダでのインクルード禁止。

#include <nw/g3d/g3d_config.h>

#if NW_G3D_IS_HOST_WIN

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>

namespace nw { namespace g3d { namespace fnd { namespace detail {

struct CreateWndArg
{
    CreateWndArg()
        : className("g3ddemo_window")
        , wndProc(NULL)
        , wndName("g3d demo")
        , left(CW_USEDEFAULT)
        , top(CW_USEDEFAULT)
        , width(1280)
        , height(720)
    {
    }

    const char* className;
    WNDPROC wndProc;
    const char* wndName;
    int left;
    int top;
    int width;
    int height;
};

HWND CreateWnd(const CreateWndArg& arg = CreateWndArg());
bool DestroyWnd(HWND hWnd);

HWND CreateSystemWnd();

int SetPixelFormat(HDC hDC);

HGLRC CreateGLContext(HDC hDC, HGLRC hSharedRC);
void DeleteGLContext(HGLRC hRC);

}}}} // namespace nw::g3d::fnd::detail

#endif // NW_G3D_IS_HOST_WIN

#endif // NW_G3D_FND_WINUTILITY_H_
