﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_FND_GX2STRUCT_H_
#define NW_G3D_FND_GX2STRUCT_H_

#include <nw/g3d/g3d_config.h>

NW_G3D_PRAGMA_PUSH_WARNINGS
NW_G3D_DISABLE_WARNING_REINTERPRET_CAST

#include <cafe/gx2/gx2Enum.h>
#include <cafe/gx2/gx2Constant.h>
#if defined(ANDROID) || defined(__APPLE__)
#include <nw/g3d/fnd/g3d_GX2Misc.h>
#else
#include <cafe/gx2/gx2Misc.h>
#endif
#include <cafe/gx2/gx2Shaders.h>
#include <cafe/gx2/gx2Surface.h>
#include <cafe/gx2/gx2Texture.h>

NW_G3D_PRAGMA_POP_WARNINGS

#if defined(GX2_NUM_COMPUTE_SHADER_REGISTERS) && NW_G3D_USE_COMPUTE_SHADER
#define NW_G3D_COMPUTE_SHADER_ENABLE 1
#endif

#if CAFE_OS_SDK_VERSION >= 21201
#define NW_G3D_OFFLINE_DL_ENABLE 1
#endif

#ifndef GX2_NUM_COMPUTE_SHADER_REGISTERS
/// \brief The number of registers used to describe compute shaders
#define GX2_NUM_COMPUTE_SHADER_REGISTERS      12
#endif

#ifndef GX2_DISPATCH_PARAMS_ALIGNMENT
/// \brief \ref GX2DispatchParams should be aligned by this many bytes
#define GX2_DISPATCH_PARAMS_ALIGNMENT 0x10
#endif

#ifndef GX2_EXPORT_BUFFER_ALIGNMENT
/// \brief Export buffer alignment
#define GX2_EXPORT_BUFFER_ALIGNMENT 256
#endif

namespace nw { namespace g3d { namespace fnd { namespace detail {

//--------------------------------------------------------------------------------------------------
// cafe/gx2/gx2Surface.h

struct GX2SurfaceData {
    GX2SurfaceDim dim;
    u32 width;
    u32 height;
    u32 depth;
    u32 numMips;
    GX2SurfaceFormat format;
    GX2AAMode aa;
    union
    {
        GX2SurfaceUse use;
        GX2RResourceFlags resourceFlags;
    };
    u32 imageSize;
    union
    {
        u32 imagePtr;
        u32 pMem;
    };
    u32 mipSize;
    u32 mipPtr;
    GX2TileMode tileMode;
    u32 swizzle;
    u32 alignment;
    u32 pitch;
    u32 mipOffset[ GX2_LOG2_MAX_TEXTURE_SIZE ];

};

struct GX2ColorBufferData {
    GX2SurfaceData surface;
    u32 viewMip;
    u32 viewFirstSlice;
    u32 viewNumSlices;
    u32 auxPtr;
    u32 auxSize;
    u32 _regs[GX2_NUM_COLOR_BUFFER_REGISTERS];

};

struct GX2DepthBufferData {
    GX2SurfaceData surface;
    u32 viewMip;
    u32 viewFirstSlice;
    u32 viewNumSlices;
    u32 hiZPtr;
    u32 hiZSize;
    f32 clearDepth;
    u32 clearStencil;
    u32 _regs[GX2_NUM_DEPTH_BUFFER_REGISTERS];

};

//--------------------------------------------------------------------------------------------------
// cafe/gx2/gx2Texture.h

struct GX2TextureData {
    GX2SurfaceData surface;
    u32 viewFirstMip;
    u32 viewNumMips;
    u32 viewFirstSlice;
    u32 viewNumSlices;
    GX2CompSel compSel;
    u32 _regs[GX2_NUM_TEXTURE_REGISTERS];

};

//--------------------------------------------------------------------------------------------------
// cafe/gx2/gx2Shaders.h

struct GX2LoopVarData
{
     u32 _regs[GX2_NUM_LOOP_VAR_U32_WORDS];
};

struct GX2VertexShaderData
{
    u32 _regs[GX2_NUM_VERTEX_SHADER_REGISTERS];
    u32 shaderSize;
    u32 shaderPtr;
    GX2ShaderMode shaderMode;
    u32 num_uniformBlocks;
    u32 uniformBlocks;
    u32 numUniforms;
    u32 uniformVars;
    u32 numInitialValues;
    u32 initialValues;
    u32 _numLoops;
    u32 _loopVars;
    u32 numSamplers;
    u32 samplerVars;
    u32 numAttribs;
    u32 attribVars;
    u32 ringItemsize;
    GX2Boolean hasStreamOut;
    u32 streamOutVertexStride[GX2_MAX_STREAMOUT_BUFFERS];
    GX2RBuffer shaderProgram;
};

struct GX2GeometryShaderData
{
    u32 _regs[GX2_NUM_GEOMETRY_SHADER_REGISTERS];
    u32 shaderSize;
    u32 shaderPtr;
    u32 copyShaderSize;
    u32 copyShaderPtr;
    GX2ShaderMode shaderMode;
    u32 numUniformBlocks;
    u32 uniformBlocks;
    u32 numUniforms;
    u32 uniformVars;
    u32 numInitialValues;
    u32 initialValues;
    u32 _numLoops;
    u32 _loopVars;
    u32 numSamplers;
    u32 samplerVars;
    u32 ringItemsize;
    GX2Boolean hasStreamOut;
    u32 streamOutVertexStride[GX2_MAX_STREAMOUT_BUFFERS];
    GX2RBuffer shaderProgram;
    GX2RBuffer copyShaderProgram;
};

struct GX2PixelShaderData
{
    u32  _regs[GX2_NUM_PIXEL_SHADER_REGISTERS];
    u32 shaderSize;
    u32 shaderPtr;
    GX2ShaderMode shaderMode;
    u32 numUniformBlocks;
    u32 uniformBlocks;
    u32 numUniforms;
    u32 uniformVars;
    u32 numInitialValues;
    u32 initialValues;
    u32 _numLoops;
    u32 _loopVars;
    u32 numSamplers;
    u32 samplerVars;
    GX2RBuffer shaderProgram;
};

struct GX2FetchShaderData
{
    // Fetch shader type
    GX2FetchShaderType type;
    u32 _regs[GX2_NUM_FETCH_SHADER_REGISTERS];
    u32 shaderSize;
    u32 shaderPtr;
    u32 num_attribs;
    u32 _num_divisors;
    u32 _divisors[2];

};

struct GX2ComputeShaderData
{
    u32 _regs[GX2_NUM_COMPUTE_SHADER_REGISTERS];
    u32 shaderSize;
    u32 shaderPtr;
    u32 numUniformBlocks;
    u32 uniformBlocks;
    u32 numUniforms;
    u32 uniformVars;
    u32 numInitialValues;
    u32 initialValues;
    u32 _numLoops;
    u32 _loopVars;
    u32 numSamplers;
    u32 samplerVars;
    u32 layout_size_x;
    u32 layout_size_y;
    u32 layout_size_z;
    GX2Boolean Over64Mode;
    u32 numWavesPerSIMD;
    GX2RBuffer shaderProgram;
};

struct GX2DispatchParamsData
{
    u32 num_groups_x;
    u32 num_groups_y;
    u32 num_groups_z;
    u32 padding;
};

}}}} // namespace nw::g3d::fnd::detail

#endif // NW_G3D_FND_GX2STRUCT_H_
