﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>
#if EFT_IS_WIN
#include <Windows.h>
#endif

//------------------------------------------------------------------------------
namespace nw    {
namespace eftvw2 {

//---------------------------------------------------------------------------
//! @brief        エフェクトビューア用の簡易文字列
//---------------------------------------------------------------------------
struct VwrString
{
#if EFT_IS_WIN
    static const int MAX_STRING = MAX_PATH; //!< TBD
#else
    static const int MAX_STRING = 260;      //!< TBD
#endif

    //---------------------------------------------------------------------------
    //! @brief  文字列へのアドレスを取得する
    //! @return 文字列へのアドレス
    //---------------------------------------------------------------------------
    const char* Cstr() const
    {
        return Value;
    }

    //---------------------------------------------------------------------------
    //! @brief                  文字列をコピーする
    //! @param[in] SrcString    コピー元文字列の先頭アドレス
    //---------------------------------------------------------------------------
    void Copy( const char* SrcString )
    {
#if EFT_IS_WIN
        strcpy_s( Value, MAX_STRING, SrcString );
#else
        EFT_ASSERT( strlen( SrcString ) < MAX_STRING );
        strcpy( Value, SrcString );
#endif
    }

    mutable char Value[ MAX_STRING ];   //!< 文字列配列
};


//------------------------------------------------------------------------------
} // namespace eftvw2
} // namespace nw
