﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw   {
namespace eft2 {

struct EmitterSet;

//---------------------------------------------------------------------------
//! @brief  エフェクト操作ハンドルクラスです。
//!
//!         生成済みのエミッタセットへは、このクラスを取得できます。
//---------------------------------------------------------------------------
class Handle
{
public:
    //----------------------------------------
    //! @name   コンストラクタ
    //@{

    //---------------------------------------------------------------------------
    //! @brief  コンストラクタ。
    //---------------------------------------------------------------------------
    Handle() : m_EmitterSet( NULL ){}

    //@}

    //----------------------------------------
    //! @name   ハンドルへの操作
    //@{

    //---------------------------------------------------------------------------
    //! @brief  ハンドルを無効化します。
    //!
    //!         放出済みのエミッタセットはそのままに、ハンドルだけ無効化します。
    //!         ハンドルを使いまわす時に使用します。
    //---------------------------------------------------------------------------
    void Invalidate()
    {
        m_CreateID   = 0xFFFFFFFF;
        m_EmitterSet = NULL;
    }

    //---------------------------------------------------------------------------
    //! @brief  エミッタセットへのポインタを取得します。
    //! @return エミッタセットへのポインタ
    //---------------------------------------------------------------------------
    EmitterSet* GetEmitterSet(){ return m_EmitterSet; }

    //---------------------------------------------------------------------------
    //! @brief  エミッタセットへのポインタを取得します。( const版 )
    //! @return エミッタセットへのポインタ
    //---------------------------------------------------------------------------
    const EmitterSet* GetEmitterSet() const{ return m_EmitterSet; }

    //---------------------------------------------------------------------------
    //! @brief  ハンドルが有効かどうかチェックします。
    //! @return ハンドルが有効かどうか
    //---------------------------------------------------------------------------
    bool IsValid() const
    {
        return m_EmitterSet != NULL && m_CreateID == m_EmitterSet->GetCreateID();
    }

    //@}

private:
    EmitterSet*         m_EmitterSet;   //!< エミッタセットへのポインタ
    u32                 m_CreateID;     //!< エミッタセットの生成ＩＤ

    friend class System;
};

} // namespace eft2
} // namespace nw
