﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>

namespace nw      {
namespace eft2    {


//---------------------------------------------------------------------------
//! @brief DisplayList
//---------------------------------------------------------------------------
struct DisplayList
{
public:
    //-------------------------------------------
    //! @brief 初期化処理
    //! @param[in] displayListBuffer     ディスプレイリストバッファへのポインタ
    //! @param[in] displayListBufferSize ディスプレイリストバッファのサイズ
    //-------------------------------------------
    void Initialize( void* displayListBuffer, u32 displayListBufferSize )
    {
        m_DispListBuffer = displayListBuffer;
        m_DispListSize   = displayListBufferSize;
#if EFT_OPENGL
        m_DisplayListID  = glGenLists( 1 );
#endif
    }

    //-------------------------------------------
    //! @brief 終了処理
    //-------------------------------------------
    void Finalize(){}

    //-------------------------------------------
    //! @brief ディスプレイリストを有効にする
    //-------------------------------------------
    void BindDisplayList()
    {
#if EFT_OPENGL
        glNewList( m_DisplayListID, GL_COMPILE );
#endif
    }

    //-------------------------------------------
    //! @brief ディスプレイリストを無効にする
    //-------------------------------------------
    void UnbindDisplayList()
    {
#if EFT_OPENGL
        glEndList();
#endif
    }

    //-------------------------------------------
    //! @brief ディスプレイリストをコールする
    //-------------------------------------------
    void CallDisplayList()
    {
#if EFT_OPENGL
        EFT_ASSERT( m_DisplayListID != 0 );
        glCallList( m_DisplayListID );
#endif
    }

    //-------------------------------------------
    //! @brief ディスプレイリストのサイズを取得する
    //! @return ディスプレイリストのサイズ
    //-------------------------------------------
    u32 GetDisplayListBufferSize() const
    {
        return m_DispListUsedSize;
    }

private:
    void*               m_DispListBuffer;   //!< ディスプレイリストバッファへのポインタ
    u32                 m_DispListSize;     //!< ディスプレイリストのサイズ
    u32                 m_DispListUsedSize; //!< ディスプレイリストの使用中のサイズ
#if EFT_OPENGL
    GLuint              m_DisplayListID;    //!< ディスプレイリストID
#endif
};

} // namespace eftdemo
} // namespace nw
