﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eft2_Callback.h>

namespace nw    {
namespace eft2  {

//---------------------------------------------------
//! @brief  範囲内ループを管理するクラスです。
//---------------------------------------------------
class AreaLoopSystem
{
public:
    static const EmitterPluginResourceIndex  PluginId = EFT_EMITTER_PLUGIN_ID_4;   //!< エミッタプラグインID
public:
    //------------------------------------------------------------------------------
    //! @brief          エミッタ描画コールバック
    //! @param[in] arg  コールバック引数
    //! @return         正常終了した場合trueを返します。
    //------------------------------------------------------------------------------
    static bool _EmitterDrawCallback( EmitterDrawArg& arg );

    //------------------------------------------------------------------------------
    //! @brief          RenderStateセットコールバック
    //! @param[in] arg  コールバック引数
    //! @return         正常終了した場合trueを返します。
    //------------------------------------------------------------------------------
    static bool _RenderStateSetCallback( RenderStateSetArg& arg );

    //------------------------------------------------------------------------------
    //! @brief              初期化処理
    //! @param[in] system   eft2::System クラスのポインタ
    //! @return             正常終了した場合trueを返します。
    //------------------------------------------------------------------------------
    static bool Initialize( System* system );

private:
    //------------------------------------------------------------------------------
    //! @brief          コンストラクタ
    //------------------------------------------------------------------------------
    AreaLoopSystem(){}

    //------------------------------------------------------------------------------
    //! @brief          デストラクタ
    //------------------------------------------------------------------------------
    virtual ~AreaLoopSystem(){}

    //------------------------------------------------------------------------------
    //! @brief                  描画処理
    //! @param[in] emitter      エミッタへのポインタ
    //! @param[in] shaderType   シェーダタイプ
    //! @param[in] userParam    ユーザーパラメータへのポインタ
    //! @return                 正常終了した場合trueを返します。
    //------------------------------------------------------------------------------
    static bool Draw( Emitter* emitter, ShaderType shaderType, void* userParam );
};

} // namespace eft2
} // namespace nw
