﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_CONTROLWINDOW_H_
#define NW_DW_CONTROLWINDOW_H_

#include <nw/dw/window/dw_Window.h>
#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_UIElementTreeContext.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @details :private
//!
//! @brief  UIElement を格納するウィンドウクラスです。
//---------------------------------------------------------------------------
class ControlWindow : public Window
{
private:
    typedef Window Base;

public:
    ControlWindow();
    virtual ~ControlWindow();

public:
    //! @details :private
    UIElement* GetContent() const;
    //! @details :private
    void SetContent(UIElement* pContent);

    //! @details :private
    Measurement GetMeasurement() const;
    //! @details :private
    void SetMeasurement(Measurement value);

protected:
    /* override */ bool OnCreate();
    /* override */ void OnSize();

    /* override */ void OnUpdateInputs(const nw::internal::dw::Inputs& inputs);
    /* override */ void OnUpdate(UIRenderer& renderer);
    /* override */ void OnDraw(IUIRenderContext& context, UIRenderer& renderer);

private:
    void ActivateContent();
    void DeactivateContent();
    void StretchContent();

private:
    UIElementTreeContext m_UIElementContext;
    UIElement* m_pRootElement;

    Measurement m_Measurement;
};

} // namespace dw
} // namespace internal
} // namespace nw

#endif // NW_DW_CONTROLWINDOW_H_
