﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_POINTER_H_
#define NW_DW_POINTER_H_

#include <nw/types.h>
#include <nw/dev/dev_Resource.h>
#include <math.h>
#include <nw/dw/system/dw_UIRenderer.h>

namespace nw {
namespace internal {
namespace dw {
namespace detail {

//---------------------------------------------------------------------------
//! @brief     ポインターを扱うクラスです。
//---------------------------------------------------------------------------
class Pointer
{
public:
    //---------------------------------------------------------------------------
    //! @brief     コンストラクタです。
    //---------------------------------------------------------------------------
    Pointer();

    //---------------------------------------------------------------------------
    //! @brief     デストラクタです。
    //---------------------------------------------------------------------------
    ~Pointer();


    //---------------------------------------------------------------------------
    //! @brief     初期化を行います。
    //---------------------------------------------------------------------------
    void Initialize( nw::ut::IAllocator* allocator );

    //---------------------------------------------------------------------------
    //! @brief     終了処理を行います。
    //---------------------------------------------------------------------------
    void Finalize();

    //---------------------------------------------------------------------------
    //! @brief        ポインタのタイプを設定します。
    //!
    //! @param[in]    type      設定するポインタのタイプです。
    //---------------------------------------------------------------------------
    void SetPointerType( nw::dev::PointerType type ) { m_Type = type; }

    //---------------------------------------------------------------------------
    //! @brief        現在のポインタのタイプを取得します。
    //!
    //! @return       ポインタのタイプを返します。
    //---------------------------------------------------------------------------
    nw::dev::PointerType GetPointerType() const { return m_Type; }

    //---------------------------------------------------------------------------
    //! @brief        ポインタの位置を設定します。
    //!
    //! @param[in]    pos       設定するポインタの位置です。
    //---------------------------------------------------------------------------
    void SetPosition( const nw::math::Vector2& pos ) { m_Position = pos; }

    //---------------------------------------------------------------------------
    //! @brief        現在のポインタの位置を取得します。
    //!
    //! @return       ポインタの位置を返します。
    //---------------------------------------------------------------------------
    const nw::math::Vector2& GetPosition() const { return m_Position; }

    //---------------------------------------------------------------------------
    //! @brief     ポインタの描画を行います。
    //!
    //! @param[in]    renderer  UIRenderer です。
    //---------------------------------------------------------------------------
    void Draw( nw::internal::dw::UIRenderer& renderer );


private:
    nw::ut::IAllocator* m_Allocator;
    nw::dev::PointerType m_Type;
    nw::math::Vector2 m_Position;

    bool m_IsIntialized;

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    nw::gfnd::TextureGL m_Texture;
#else
    GX2Texture m_TextureArrow;
    nw::gfnd::TextureCafeGX2 m_Texture;
#endif
    u8* m_TexImage;
};

} // namespace nw::internal::dw::detail
} // namespace nw::internal::dw
} // namespace nw::internal
} // namespace nw

#endif // NW_DW_POINTER_H_
