﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief UI要素のユーティリティクラスです。
//---------------------------------------------------------------------------
class UIElementUtility
{
public:
    virtual ~UIElementUtility() {}
    static const u32 INVALID_INDEX = static_cast<u32>( -1 );

public:
    //---------------------------------------------------------------------------
    //! @brief UI要素の単項関数オブジェクトです。
    //---------------------------------------------------------------------------
    class UnaryFunction
    {
    public:
        virtual ~UnaryFunction() { }

    public:
        u32 GetCurrentLevel();

        virtual bool operator ()(UIElement& element) = 0;

    protected:
        virtual bool OnCurrentLevelChanged()
        {
            return true;
        }

    private:
        bool SetCurrentLevel(u32 value);

    private:
        u32 m_CurrentLevel;

        friend class UIElementUtility;
    };

public:
    static nw::math::Vector2 PositionToChildClient(const nw::math::Vector2 position, const UIElement& childElement);
    static void PositionToChildClient(nw::math::Vector2* pPosition, const UIElement& childElement);
    static nw::math::Vector2 PositionToParentClient(const nw::math::Vector2 position, const UIElement& parentElement);
    static void PositionToParentClient(nw::math::Vector2* pPosition, const UIElement& parentElement);
    static bool HitTest(const nw::math::Vector2 position, const UIElement& element);

    static void ForChildElements(const UIElement& element, UnaryFunction& functor);
    static void ForAllElements(const UIElement& element, UnaryFunction& functor);

    static u32 IndexOf(const UIElement& targetElement, const UIElement& element);
    static u32 IndexOf(const UIElement& element, UnaryFunction& functor);
    static u32 IndexOf(const UIElementList& elements, const UIElement& element);
    static u32 IndexOf(const UIElementList& elements, UnaryFunction& functor);

    static UIElement* GetFocusedElement(const UIElement& element);
    static UIElement* GetEndFocusableElement(const UIElement& element);

    static UIElement* GetPointerOverElement(const UIElement& element);

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
    static void PrintUIElementTree(const UIElement& element);
#endif

private:
    static bool ForAllElementsInternal(const UIElement& element, UnaryFunction& functor, u32 level);
};

} // dw
} // internal
} // nw
