﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Rect.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

class UIElementList;

//---------------------------------------------------------------------------
//! @brief UI要素の配置機能を実装するユーティリティクラスです。
//---------------------------------------------------------------------------
class UIElementAligner
{
public:
    static nw::ut::Rect GetHorizontalAlignedRect(UIElement& element, f32 x, f32 width);
    static nw::ut::Rect GetVerticalAlignedRect(UIElement& element, f32 y, f32 height);

    static inline nw::ut::Rect GetAlignedRect(UIElement& element, f32 x, f32 y, f32 width, f32 height)
    {
        nw::ut::Rect result         = GetHorizontalAlignedRect(element, x, width);
        nw::ut::Rect resultVertical = GetVerticalAlignedRect(element, y, height);

        result.top = resultVertical.top;
        result.bottom = resultVertical.bottom;

        return result;
    }

    static inline nw::ut::Rect GetAlignedRect(UIElement& element, const nw::math::Vector2& topLeft, const nw::math::Vector2& size)
    {
        return GetAlignedRect(element, topLeft.x, topLeft.y, size.x, size.y);
    }
};

} // dw
} // internal
} // nw
