﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
template<u32 TTabCount>
FixedTabControl<TTabCount>::FixedTabControl()
{
    Initialize();
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::Initialize()
{
    m_TabPanel.SetContents( m_RootContents );

    m_Tabs.SetOrientation( HORIZONTAL );
    m_Tabs.SetIsFocusable(true);

    m_Container.GetContents().AddItem( &m_TabPanel );
    m_Container.GetContents().AddItem( &m_Tabs );

    m_Contents.AddItem( &m_Container );
    SetContents( m_Contents );
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::AddTabItem( UIElement* pItem, const char* tabName )
{
    u32 tabIndex = GetTabCount();

    m_TabLabel[ tabIndex ].SetIsBordered( m_TabsBordered );
    m_TabLabel[ tabIndex ].SetBackgroundColor( m_TabsBackgroundColor );
    m_TabLabel[ tabIndex ].SetTextColor( m_TabsTextColor );
    m_TabLabel[ tabIndex ].SetText( tabName );
    m_Tabs.GetContents().AddItem( &m_TabLabel[ tabIndex ] );

    m_TabItem[ tabIndex ] = pItem;

    SelectTab( 0 );
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabIsBordered( bool value )
{
    m_TabsBordered = value;

    for ( int i = 0; i < m_Tabs.GetContents().GetCount(); ++i )
    {
        m_Tabs.GetContents().GetItem( i )->SetIsBordered( m_TabsBordered );
    }
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabSelectedBackgroundColor( bool value )
{
    m_TabsSelectedBackgroundColor = value;

    SetTabsBackgroundColor();
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabBackgroundColor( bool value )
{
    m_TabsBackgroundColor = value;

    SetTabsBackgroundColor();
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabSelectedTextColor( bool value )
{
    m_TabsSelectedTextColor = value;

    SetTabsTextColor();
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabTextColor( bool value )
{
    m_TabsTextColor = value;

    SetTabsTextColor();
}


//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::OnUpdate(const UIElementTreeContext& context)
{
    for ( int i = 0; i < GetTabCount(); ++i )
    {
        if ( i == m_CurrentTabIndex )
        {
            continue;
        }

        m_TabItem[ i ]->Update( context );
    }
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SelectTab(s32 index)
{
    NW_ASSERT( 0 <= index && index < GetTabCount() );

    m_RootContents.ClearItems();
    m_RootContents.AddItem( m_TabItem[ index ] );

    if ( this->GetIsContainsFocus() )
    {
        if ( m_TabItem[ index ]->GetIsFocusable() )
        {
            m_TabItem[ index ]->SetFocus();
        }
        else
        {
            // MEMO: TabItem が Focusable ではない場合は Tab にフォーカスを合わせておきます。
            m_Tabs.SetFocus();
        }
    }

    m_CurrentTabIndex = index;

    SetTabsBackgroundColor();
    SetTabsTextColor();
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabsBackgroundColor()
{
    for ( int i = 0; i < m_Tabs.GetContents().GetCount(); ++i )
    {
        if ( i == m_CurrentTabIndex )
        {
            m_TabLabel[i].SetBackgroundColor( m_TabsSelectedBackgroundColor );
        }
        else
        {
            m_TabLabel[i].SetBackgroundColor( m_TabsBackgroundColor );
        }
    }
}

//---------------------------------------------------------------------------
template<u32 TTabCount>
void
FixedTabControl<TTabCount>::SetTabsTextColor()
{
    for ( int i = 0; i < m_Tabs.GetContents().GetCount(); ++i )
    {
        if ( i == m_CurrentTabIndex )
        {
            m_TabLabel[i].SetTextColor( m_TabsSelectedTextColor );
        }
        else
        {
            m_TabLabel[i].SetTextColor( m_TabsTextColor );
        }
    }
}

} /* namespace dw */
} /* namespace internal */
} /* namespace nw */
