﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEV_UTILITY_H_
#define NW_DEV_UTILITY_H_

#include <nw/dev/dev_Config.h>

#if defined( NW_DEV_ENABLED )

#include <nw/types.h>
#include <nw/dev/dev_Memory.h>

#include <string>

#define NW_DEV_LOG  NW_LOG

namespace nw
{
namespace dev
{

typedef std::basic_string<char, std::char_traits<char>, nw::dev::StdAllocator<char> > String;
typedef std::basic_string<char16, std::char_traits<char16>, nw::dev::StdAllocator<char16> > String16;
typedef std::basic_string<char32, std::char_traits<char32>, nw::dev::StdAllocator<char32> > String32;

} // namespace nw::dev
} // namespace nw

#endif // NW_DEV_ENABLED

#endif // NW_DEV_UTILITY_H_

