﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_TOUCH_DRAG_BUTTON_H_
#define NW_CTRL_TOUCH_DRAG_BUTTON_H_

#include <nw/ctrl/ctrl_DragButton.h>

namespace nw
{

namespace ctrl
{

//---------------------------------------------------------------------------
//! @brief タッチスクリーン用のボタンを掴んで移動させることができるボタンです。
//!
//! @details
//! 他のボタンと異なり、このボタンにはON/OFFアニメがありません。
//!
//! タッチスクリーン上で当たりが発生すると、Touchアニメが再生されて、ドラッグした
//! 状態になります。タッチスクリーンから離すとReleaseアニメが再生されて元に戻ります。
//!
//! Touchアニメは機能アニメの1つ目に、Releaseアニメは2つ目に指定してください。
//!
//---------------------------------------------------------------------------
class TouchDragButton : public DragButton
{
public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(DragButton);

    //! @brief コンストラクタです。
    //!
    TouchDragButton();

    //! @brief ボタンの構築を行います。
    //!
    //! @param[in] controlSrc   コントロールの情報
    //! @param[in,out] layout   所属するレイアウト
    //!
    void Build(const lyt::ControlSrc& controlSrc, lyt::Layout* layout);

protected:
    //! @brief ボタンの挙動をカスタマイズするためにオーバーライドします。
    //!
    virtual bool ProcessOn();
    virtual bool ProcessCancel();
    virtual void FinishCancel();

};

} // namespace nw::ctrl
} // namespace nw

#endif // NW_CTRL_TOUCH_DRAG_BUTTON_H_
