﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief シェアページを開くのに利用される型や定数の宣言(非公開)
 */

#pragma once

namespace nn { namespace web {

//--------------------------------------------------------------------------
/**
 * @brief 起動時に開くページの種類を表す定数です。
 */
enum ShareStartPage
{
    ShareStartPage_SharePage,      //!< SharePage を開きます。
    ShareStartPage_SettingsPage,   //!< SettingPage を開きます。
    ShareStartPage_Max             //!< (列挙子の総数です。使用しないでください。)
};

//--------------------------------------------------------------------------
/**
 * @brief シェアページ表示の終了理由を表す定数です。
 */
enum ShareExitReason
{
    ShareExitReason_EndButtonPressed = 0,                         //!< 「おわる」ボタンが押された。
    ShareExitReason_BackButtonPressed = 1,                        //!< 「戻る」ボタンが押された。
    ShareExitReason_ExitMessage = 2,                              //!< システムからの終了メッセージを受け取りました。
    ShareExitReason_CallbackUrlReached = 3,                       //!< コールバック URL に到達した。
    ShareExitReason_LastWindowDeleted = 4,                        //!< 最後のウインドウが削除された。
    ShareExitReason_LocalNetworkDisconnectionDenied = 5,          //!< ローカル通信の切断確認が許可されなかった
    ShareExitReason_MediaPlayerClosed = 6,                        //!< メディアプレイヤーが閉じられた。
    ShareExitReason_CausedByWebPage = 7,                          //!< ウェブページから終了要求があり終了された。
    ShareExitReason_UserSelectionCanceled = 8,                    //!< ユーザー選択がキャンセル操作で閉じられた。
    ShareExitReason_NetworkConnectionFailed = 9,                  //!< ネットワーク接続に失敗した。
    ShareExitReason_SystemUpdateRequired = 10,                    //!< 本体更新が必要とされた。
    ShareExitReason_SnsPostRestrictedByParentalControl = 11,      //!< SNS 投稿がペアレンタルコントロールによって制限されていた。
    ShareExitReason_PlayingVideoRestrictedByParentalControl = 13, //!< 動画の再生がペアレンタルコントロールによって制限されていた。
    ShareExitReason_Unexpected = 20                               //!< 想定外の要因で終了した。
};

//--------------------------------------------------------------------------
/**
* @brief 画像投稿の成否を表す定数です。
*/
enum SharePostResult
{
    SharePostResult_Success,  //!< 投稿に成功した。
    SharePostResult_Cancel,   //!< 投稿がキャンセルされた。
    SharePostResult_Error,    //!< 投稿に失敗した。
    SharePostResult_Max       //!< (列挙子の総数です。使用しないでください。)
};

}} // namespace nn::web
