﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief オフライン HTML を開くのに利用する API 宣言(非公開)
 */

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/web/web_OfflineShowArg.h>
#include <nn/web/web_OfflineShowArgPrivate.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
/**
 * @brief アプリケーションの「リーガル情報」を開きます。
 *
 * @param[out]  pOutputOfflineHtmlPageReturnValue   アプリケーションの「リーガル情報」を開いた戻り値の格納先を指定してください。
 * @param[in]   arg                             アプリケーションの「リーガル情報」を開くのに利用されるパラメータです。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess                    リーガル情報の表示に成功し、操作によって表示が終了されました。
 * @retval nn::la::ResultLibraryAppletCanceled  リーガル情報の表示中に強制的にキャンセルが行われて表示が終了されました。
 */
nn::Result ShowApplicationLegalInformationPage(
    OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const ShowApplicationLegalInformationPageArg& arg) NN_NOEXCEPT;

//------------------------------------------------------------------------
/**
 * @brief システムデータを開きます。
 *
 * @param[out]  pOutputOfflineHtmlPageReturnValue   システムデータを開いた戻り値の格納先を指定してください。
 * @param[in]   arg                             システムデータを開くのに利用されるパラメータです。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess                    システムデータの表示に成功し、操作によって表示が終了されました。
 * @retval nn::la::ResultLibraryAppletCanceled  システムデータの表示中に強制的にキャンセルが行われて表示が終了されました。
 */
nn::Result ShowSystemDataPage(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const ShowSystemDataPageArg& arg) NN_NOEXCEPT;

//------------------------------------------------------------------------
/**
 * @brief 指定したStorageからオフラインページを開いた戻り値を取得します。
 *
 * @param[in,out]   pOutputOfflineHtmlPageReturnValue   オフラインページを開いた戻り値の格納先を指定してください。
 * @param[in]       handle                          nn::applet::TryPopFromOutChannel で取得した nn::applet::StorageHandle を指定してください。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess 処理に成功しました。
 *
 * @details Unwind 時に戻り値を取得する為の機能です。
 *          handle から値を取り出すだけでストレージの破棄はしません。
 */
nn::Result GetOfflineHtmlPageReturnValueFromStorage(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT;

//------------------------------------------------------------------------
/**
 * @brief (廃止予定) 指定した Storage からオフラインページを開いた戻り値を取得します。
 * @deprecated 本関数は廃止予定です。代わりに @ref GetOfflineHtmlPageReturnValueFromStorage を使用してください。
 */
NN_DEPRECATED inline nn::Result GetOfflinePageReturnValueFromStorage(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    return GetOfflineHtmlPageReturnValueFromStorage(pOutputOfflineHtmlPageReturnValue, handle);
}

}} // namespace nn::web
