﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ログインページを開くのに利用される型や定数の宣言(非公開)
 */

#pragma once

namespace nn { namespace web {

//--------------------------------------------------------------------------
/**
 * @brief ログインページ表示の終了理由を表す定数です。
 */
enum LoginExitReason
{
    LoginExitReason_EndButtonPressed = 0,                //!< 「おわる」ボタンが押された。
    LoginExitReason_BackButtonPressed = 1,               //!< 「戻る」ボタンが押された。
    LoginExitReason_ExitMessage = 2,                     //!< システムからの終了メッセージを受け取りました。
    LoginExitReason_CallbackUrlReached = 3,              //!< コールバック URL に到達した。
    LoginExitReason_LastWindowDeleted = 4,               //!< 最後のウインドウが削除された。
    LoginExitReason_LocalNetworkDisconnectionDenied = 5, //!< ローカル通信の切断確認が許可されなかった
    LoginExitReason_MediaPlayerClosed = 6,               //!< メディアプレイヤーが閉じられた。
    LoginExitReason_CausedByWebPage = 7,                 //!< ウェブページから終了要求があり終了された。
    LoginExitReason_UserSelectionCanceled = 8,           //!< ユーザー選択がキャンセル操作で閉じられた。
    LoginExitReason_NetworkConnectionFailed = 9,         //!< ネットワーク接続に失敗した。
    LoginExitReason_SystemUpdateRequired = 10,           //!< 本体更新が必要とされた。
    LoginExitReason_Unexpected = 20                      //!< 想定外の要因で終了した。
};

//--------------------------------------------------------------------------
/**
 * @brief フッターボタンの種類を表すIDです。
 */
enum class LoginFooterButtonId
{
    StickR = 5  //!< R スティック。
};

}} // namespace nn::web
