﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief メッセージに利用する共通の型 (非公開)
 */

#pragma once

#include <nn/web/web_SessionTypes.h>

namespace nn { namespace web { namespace detail {

//------------------------------------------------------------------------
/**
 * @brief 呼び出し側から LA に送信するメッセージの種類です。
 */
enum class SendMessageKind
{
    Max,                    //!< 列挙子の総数です。

    Ack = 0x1000,           //!< Ack
    Debug = 0x4000,         //!< Debug用
};

/**
 * @brief LA から呼び出し元に送信するメッセージの種類のうち利用者側に隠しておきたい物です。
 */
enum class SessionMessageKindDetail
{
    Ack = 0x1000,           //!< Ack
};


/**
 * @brief Session でやり取りする Ack 情報の型です。
 */
struct SessionAck
{
    static SessionAck Create()
    {
        SessionAck ack;
        ack.header.kind = uint32_t(SendMessageKind::Ack);
        ack.header.size = sizeof(receivedSize) + sizeof(_reserved);
        ack.receivedSize = ack._reserved = 0;
        return ack;
    }
    SessionMessageHeader header;
    uint32_t receivedSize;
    uint32_t _reserved;
};

}}} // namespace nn::web::detail
