﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace rid {

    /**
     * @brief   システムが最後に SD カードの挿抜処理を行ったときの状態を確認します。
     *
     * @return  SD カードの挿入処理の結果が返ります。Success のときは正常に使える状態です。
     * @retval  ResultSdCardNoOwnership         他の本体で初期化された SD カードが挿入されました。
     * @retval  ResultSdCardNeedsSystemUpdate   exfat でかつ、 exfat ドライバが必要です。 SD カードを利用するためには本体更新が必要です。
     * @retval  ResultSdCardFileSystemCorrupted ファイルシステムが壊れています。
     * @retval  ResultSdCardDatabaseCorrupted   データベースが壊れています。
     * @retval  ResultSdCardNotMounted          起動後に SD カードが挿入されました。 SD カードを利用するためには再起動が必要です。
     * @retval  ResultSdCardNotInserted         SD カードが挿入されていません。
     */
    Result CheckSdCard() NN_NOEXCEPT;
}}
