﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

namespace nn
{
    namespace repair
    {
        struct InitialVector
        {
            static const int IV_SIZE = 16;
            uint8_t data[IV_SIZE];

            static InitialVector MakeZero();
        };

        struct Cmac
        {
            static const int CMAC_SIZE = 16;
            uint8_t data[CMAC_SIZE];

            bool operator==(const Cmac &cmac) const;
            bool operator!=(const Cmac &cmac) const;

            static Cmac MakeZero();
        };

        struct Id128
        {
            static const int SIZE = 16;
            uint8_t data[SIZE];

            bool operator==(const Id128 &cmac) const;
            bool operator!=(const Id128 &cmac) const;

            static Id128 MakeZero();
        };

        struct Sha256Hash
        {
            static const int SIZE = 32;
            uint8_t data[SIZE];

            bool operator==(const Sha256Hash &hash) const;
            bool operator!=(const Sha256Hash &hash) const;

            static Sha256Hash MakeZero();
            static Sha256Hash Make(void *buffer, size_t size);
        };

        struct Key128
        {
            static const int KEY_SIZE = 16;
            static const int KEY_STRING_SIZE = 32;
            uint8_t data[KEY_SIZE];

            bool operator==(const Key128 &key) const;
            bool operator!=(const Key128 &key) const;

            static bool IsValid(const char *hexString);
            static Key128 Make(uint8_t *data);
            static Key128 Make(const char *hexString);
            static Key128 MakeZero();
            static Key128 EncryptKey(Key128 source, Key128 kek);
        };

        struct Key2048
        {
            static const int KEY_SIZE = 256;
            static const int KEY_STRING_SIZE = 512;
            uint8_t data[KEY_SIZE];

            static bool IsValid(const char *hexString);
            static Key2048 Make(uint8_t *data);
            static Key2048 Make(const char *hexString);
        };

        struct Sign2048
        {
            static const int SIZE = 256;
            static const int STRING_SIZE = 512;
            uint8_t data[SIZE];

            static Sign2048 Make(uint8_t *data);
        };

        struct RsaEncryptedBlock
        {
            static const int SIZE = 256;
            uint8_t data[SIZE];
        };
    }
}
