﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace repair {

    static const char* const RequestOption = "--request";
    static const char* const ResponseOption = "--response";

    //!< 引数無しのオプションがあるか判定します
    bool HasOption(const char* option);

    //!< 引数有りのオプションがあればその引数を返します。なければnullptrを返します
    char* GetOptionArgument(const char* option);

}} // namespace nn::repair

