﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/ndd/detail/ndd_Handle.h>

namespace nn { namespace ndd {

//現状ImplとWorkerが同時にアクセスしないため、排他はしない
class Context {
public:
    enum EventId{
        EventId_SendDataUpdate,
        EventId_ReceiveData,
        EventId_DeviceScan,
    };

    //Impl向け
    void Initialize();
    void Finalize();
    void WaitReply();
    nn::os::NativeHandle AcquireHandle(EventId eventId);

    //Worker向け
    Handle GetHandle() const;
    void Signal(EventId eventId);
    void SignalReply();
    void SetHandle(Handle handle);

private:
    nn::os::SystemEventType m_SendDataUpdateEvent;
    nn::os::SystemEventType m_ReceiveDataEvent;
    nn::os::SystemEventType m_DeviceScanEvent;

    //[todo]Scanリソース（有無、バッファ）

    nn::os::EventType m_ReplyEvent;
    Handle m_Handle;
};

}}
