﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/ndd/detail/Service/ndd_Service.sfdl.h>
#include <nn/ndd/detail/ndd_Context.h>
#include <nn/ndd/detail/ndd_Queue.h>

namespace nn { namespace ndd {

class ServiceImpl
{
public:
    ServiceImpl() NN_NOEXCEPT;
    ~ServiceImpl() NN_NOEXCEPT;
    nn::Result EnableAutoCommunication() NN_NOEXCEPT;
    nn::Result DisableAutoCommunication() NN_NOEXCEPT;
    nn::Result IsAutoCommunicationEnabled(nn::sf::Out<bool> pIsEnabled) NN_NOEXCEPT;
    nn::Result IsNetworkActive(nn::sf::Out<bool> pIsActive) NN_NOEXCEPT;
    nn::Result AcquireSendDataUpdateEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result AddSendData(const nn::ndd::SendDataDescription& data) NN_NOEXCEPT;
    nn::Result ClearSendData() NN_NOEXCEPT;
    nn::Result GetSendData(nn::sf::Out<SendDataDescription> pBuffer, nn::sf::Out<std::int32_t> pCount, int offset, int count) NN_NOEXCEPT;
    nn::Result AcquireReceiveDataEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetCurrentReceiveDataCounter(nn::sf::Out<std::uint32_t> pCounter) NN_NOEXCEPT;
    nn::Result GetOldestReceiveDataCounter(nn::sf::Out<std::uint32_t> pCounter) NN_NOEXCEPT;
    nn::Result GetNextReceiveDataCounter(nn::sf::Out<std::uint32_t> pCounter) NN_NOEXCEPT;
    nn::Result GetRecentReceiveDataCounter(nn::sf::Out<std::uint32_t> pCounter, std::uint32_t counter, int count) NN_NOEXCEPT;
    nn::Result GetAvailableReceiveDataCount(nn::sf::Out<std::int32_t> pCount, std::uint32_t counter) NN_NOEXCEPT;
    nn::Result GetReceiveData(const nn::sf::OutArray<nn::ndd::ReceiveDataDescription>& pBuffer, nn::sf::Out<std::int32_t> pCount, nn::sf::Out<std::uint32_t> pNextCounter, std::uint32_t counter) NN_NOEXCEPT;
    nn::Result AddReceiveData(const nn::ndd::ReceiveDataDescription& data) NN_NOEXCEPT;
    nn::Result ClearReceiveData() NN_NOEXCEPT;
    nn::Result ClearDataIdFilter() NN_NOEXCEPT;
    nn::Result AcquireDeviceScanEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result StartDeviceScan() NN_NOEXCEPT;
    nn::Result CancelDeviceScan() NN_NOEXCEPT;
    nn::Result GetDeviceScanResult(const nn::sf::OutArray<nn::ndd::ReceiveDataDescription>& pBuffer, nn::sf::Out<std::int32_t> pCount) NN_NOEXCEPT;
private:
    Context m_Context;
    Message m_Message;
};

class ServiceCreatorImpl
{
public:
    nn::Result CreateNddService(nn::sf::Out<nn::sf::SharedPointer<nn::ndd::IService>> pOutService) NN_NOEXCEPT;
};

}}  // namespace nn::ndd
