﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/nd/service/nd_IService.sfdl.h>
#include <nn/nd/service/nd_ReceiveDataManager.h>
#include <nn/nd/service/nd_ScanManager.h>
#include <nn/nd/service/nd_SendDataManager.h>
#include <nn/nd/service/nd_Service.h>
#include <nn/nd/service/nd_UserIdManager.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace nd { namespace service {

class ServiceResource
{
public:
    explicit ServiceResource(nn::MemoryResource& allocator, void* networkThreadStack, size_t networkThreadStackSize) NN_NOEXCEPT;

    sf::SharedPointer<IServiceForSystem> GetSystemServicePointer() const NN_NOEXCEPT
    {
        return sf::SharedPointer<IServiceForSystem>(m_pServiceForSystem);
    }

    sf::SharedPointer<IServiceForApplication> GetApplicationServicePointer() const NN_NOEXCEPT
    {
        return sf::SharedPointer<IServiceForApplication>(m_pServiceForApplication);
    }

private:
    void InitializeImpl() NN_NOEXCEPT;

    nn::MemoryResource& m_Allocator;
    sf::EmplacedRef<IServiceForSystem, ServiceForSystem> m_pServiceForSystem;
    sf::EmplacedRef<IServiceForApplication, ServiceForApplication> m_pServiceForApplication;

    service::UserIdManager m_UserIdManager;
    service::ReceiveDataManager m_ReceiveDataManager;
    service::SendDataManager m_SendDataManager;
    service::ScanManager m_ScanManager;
};

}}} // ~nn::nd::service
