﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/nd/service/nd_IService.sfdl.h>
#include <nn/nd/service/nd_ReceiveDataManager.h>
#include <nn/nd/service/nd_ScanManager.h>
#include <nn/nd/service/nd_SendDataManager.h>
#include <nn/ndd/ndd_Types.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_IServiceObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace nd { namespace service {

class ServiceBase
    : public sf::ISharedObject
{
public:
    explicit ServiceBase(
        nn::MemoryResource& allocator,
        ReceiveDataManager& receiveDataManager,
        SendDataManager& sendDataManager) NN_NOEXCEPT;

    // アプリ・システム共通 API

protected:
    // 共通リソース
    nn::MemoryResource& m_Allocator;
    ReceiveDataManager& m_ReceiveDataManager;
    SendDataManager& m_SendDataManager;
};


class ServiceForSystem
    : public ServiceBase
{
public:
    explicit ServiceForSystem(
        nn::MemoryResource& allocator,
        ReceiveDataManager& receiveDataManager,
        SendDataManager& sendDataManager,
        ScanManager& scanManager) NN_NOEXCEPT;

    // システム向け API
    nn::Result SetSystemData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ClearSystemData(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetNeighborInfoUpdateEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result GetReceivableNeighborInfoCountForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ReceiveNeighborInfoForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SetSender(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetSender(nn::sf::Out<bool> pOutSenderExists, nn::sf::Out<nn::account::Uid> pOutSender) NN_NOEXCEPT;
    nn::Result CreateScannerForSystem(nn::sf::Out<nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT;

    // デバッグ向け API
    nn::Result AddReceivedNeighborInfoForSystemForDebug(const nn::sf::InArray<nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT;
    nn::Result GetSendDataForDebug(nn::sf::Out<nn::ndd::SendDataDescription> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ClearReceiveCounterForDebug(const nn::account::Uid& uid) NN_NOEXCEPT;

private:
    ScanManager& m_ScanManager;
};


class ServiceForApplication
    : public ServiceBase
{
public:
    explicit ServiceForApplication(
        nn::MemoryResource& m_Allocator,
        ReceiveDataManager& receiveDataManager,
        SendDataManager& sendDataManager) NN_NOEXCEPT;

    // アプリ向け API
    nn::Result SetApplicationData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ClearApplicationData(const nn::account::Uid& uid) NN_NOEXCEPT;
};

}}} // ~namespace nn::nd::service
