﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/nd/nd_TypesForSystem.h>
#include <nn/nd/service/nd_UserIdManager.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nd { namespace service {

class ReceiveDataManager
{
    static const int DefaultReceivableCount = 10;
private:
    class UserData
    {
    public:
        account::Uid m_Uid = account::InvalidUid;
        int m_ReceivableCount = DefaultReceivableCount;
        uint32_t m_NextReadCounter = 0u;

        UserData() NN_NOEXCEPT {};
        void Reset() NN_NOEXCEPT;
        void Initialize(const account::Uid& uid) NN_NOEXCEPT;
        bool IsInitialized() const NN_NOEXCEPT;
    };

public:
    explicit ReceiveDataManager(UserIdManager& userIdManager) NN_NOEXCEPT
        : m_UserIdManager(userIdManager)
    {};
    void Initialize(const util::Span<const account::Uid>& uids) NN_NOEXCEPT;
    void Update(const util::Span<const account::Uid>& newUids) NN_NOEXCEPT;

    int GetReceivableNeighborInfoCountForSystem(const account::Uid& uid) NN_NOEXCEPT;
    int ReceiveNeighborInfoForSystem(NeighborInfoForSystem out[], int outCount, const account::Uid& uid) NN_NOEXCEPT;
    os::SystemEvent* GetNeighborInfoUpdateEventForSystem() NN_NOEXCEPT;
    void SignalNeighborInfoUpdateEventForSystem() NN_NOEXCEPT;

    void ClearReceiveCounterForDebug(const account::Uid& uid) NN_NOEXCEPT;

private:
    void UpdateUnsafe(const util::Span<const account::Uid>& newUids) NN_NOEXCEPT;
    UserData* FindOrInitUserDataUnsafe(const account::Uid& uid) NN_NOEXCEPT;

    mutable os::SdkMutex m_Mutex;
    os::SystemEvent m_ReceiveEventForSystem{ os::EventClearMode_ManualClear, true }; //!< TORIAEZU: 1つ。Encounter と HOMEメニューがそれぞれ利用する、などが考えられるので、要複数対応。
    std::array<UserData, account::UserCountMax> m_UserDatas;

    UserIdManager& m_UserIdManager;
};

}}} // ~namespace nn::nd::service
