﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      nd モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_ND_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nd, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_ND_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_ND_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_ND_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_ND_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(nd, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_ND_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_ND_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_ND_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_ND_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(nd, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_ND_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_ND_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_ND_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nd, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_ND_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nd, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_ND_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_ND_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_ND_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_ND_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nd, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_ND_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_ND_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_ND_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nd, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_ND_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Trace, 0, format, args)
#define NN_DETAIL_ND_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Trace, 1, format, args)
#define NN_DETAIL_ND_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Trace, 2, format, args)
#define NN_DETAIL_ND_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Trace, 3, format, args)

#define NN_DETAIL_ND_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Info, 0, format, args)
#define NN_DETAIL_ND_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Info, 1, format, args)
#define NN_DETAIL_ND_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Info, 2, format, args)
#define NN_DETAIL_ND_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Info, 3, format, args)

#define NN_DETAIL_ND_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Warn, 0, format, args)
#define NN_DETAIL_ND_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Warn, 1, format, args)
#define NN_DETAIL_ND_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Warn, 2, format, args)
#define NN_DETAIL_ND_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Warn, 3, format, args)

#define NN_DETAIL_ND_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Error, 0, format, args)
#define NN_DETAIL_ND_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Error, 1, format, args)
#define NN_DETAIL_ND_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Error, 2, format, args)
#define NN_DETAIL_ND_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Error, 3, format, args)

#define NN_DETAIL_ND_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Fatal, 0, format, args)
#define NN_DETAIL_ND_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Fatal, 1, format, args)
#define NN_DETAIL_ND_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Fatal, 2, format, args)
#define NN_DETAIL_ND_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nd, Fatal, 3, format, args)

#define NN_DETAIL_ND_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nd, Trace, 0, text, length)
#define NN_DETAIL_ND_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Trace, 1, text, length)
#define NN_DETAIL_ND_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Trace, 2, text, length)
#define NN_DETAIL_ND_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Trace, 3, text, length)

#define NN_DETAIL_ND_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(nd, Info, 0, text, length)
#define NN_DETAIL_ND_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Info, 1, text, length)
#define NN_DETAIL_ND_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Info, 2, text, length)
#define NN_DETAIL_ND_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Info, 3, text, length)

#define NN_DETAIL_ND_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(nd, Warn, 0, text, length)
#define NN_DETAIL_ND_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Warn, 1, text, length)
#define NN_DETAIL_ND_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Warn, 2, text, length)
#define NN_DETAIL_ND_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nd, Warn, 3, text, length)

#define NN_DETAIL_ND_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nd, Error, 0, text, length)
#define NN_DETAIL_ND_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Error, 1, text, length)
#define NN_DETAIL_ND_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Error, 2, text, length)
#define NN_DETAIL_ND_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Error, 3, text, length)

#define NN_DETAIL_ND_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nd, Fatal, 0, text, length)
#define NN_DETAIL_ND_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Fatal, 1, text, length)
#define NN_DETAIL_ND_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Fatal, 2, text, length)
#define NN_DETAIL_ND_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nd, Fatal, 3, text, length)
