﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/idc/migration_SharedBufferConnectionManager.h>
#include <nn/migration/idc/detail/migration_Util.h>

namespace nn { namespace migration { namespace idc {

/**
* @brief 共有バッファによる通信路の実装。
*/
class SharedBufferConnection
{
    // 接続状態管理用に ID を取得するための friend 宣言
    friend class SharedBufferConnectionManager;
    friend void swap(SharedBufferConnection& o0, SharedBufferConnection& o1) NN_NOEXCEPT;
    NN_DISALLOW_COPY(SharedBufferConnection);

public:
    SharedBufferConnection() NN_NOEXCEPT;
    SharedBufferConnection(SharedBufferConnectionManager* pManager, int id, SharedBufferConnectionManager::SharedBuffer* pSendResource, SharedBufferConnectionManager::SharedBuffer* pRecvResource) NN_NOEXCEPT;
    SharedBufferConnection(SharedBufferConnection&& rhs) NN_NOEXCEPT;
    ~SharedBufferConnection() NN_NOEXCEPT;

    SharedBufferConnection& operator =(SharedBufferConnection&& rhs) NN_NOEXCEPT;

    Result Send(size_t* pOutSentSize, const void* stream, size_t size, int timeoutSeconds, const migration::detail::Cancellable* pCancellable, detail::TransferSpeedMonitor* pSpeedMonitor = nullptr) const NN_NOEXCEPT;
    Result Receive(size_t* pOutReceivedSize, void* outStream, size_t outStreamSize, int timeoutSeconds, const migration::detail::Cancellable* pCancellable, detail::TransferSpeedMonitor* pSpeedMonitor = nullptr) const NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;

private:
    SharedBufferConnectionManager* m_pManager;
    int m_Id;
    SharedBufferConnectionManager::SharedBuffer* m_pSendBuffer;
    SharedBufferConnectionManager::SharedBuffer* m_pRecvBuffer;
};

}}}
