﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/migration/idc/migration_CommandTypes.h>

namespace nn { namespace migration { namespace idc {

#if defined (NN_BUILD_CONFIG_OS_HORIZON)

/**
    @brief  通信プロトコルの暗号鍵の交換を行うメッセージの暗号化・復号化を行うクラス。
*/
class KeyExchangeCommandEncryptor
{
public:
    KeyExchangeCommandEncryptor() NN_NOEXCEPT;
    explicit KeyExchangeCommandEncryptor(const KeyExchangeCommandConfig::Salt& salt) NN_NOEXCEPT;

    void Encrypt(
        void* outEncrypted, size_t encryptedSize,
        const void* plain, size_t plainSize,
        const void* iv, size_t ivSize) const NN_NOEXCEPT;

    void Decrypt(
        void* outPlain, size_t outPlainSize,
        const void* encrypted, size_t encryptedSize,
        const void* iv, size_t ivSize) const NN_NOEXCEPT;

    void GenerateMac(void* outMac, size_t macSize, const void* data, size_t dataSize) const NN_NOEXCEPT;
    void GenerateMacWithSalt(void* outMac, size_t macSize, const KeyExchangeCommandConfig::Challenge& challenge) const NN_NOEXCEPT;
private:
    KeyExchangeCommandConfig::Salt m_Salt;
};

#endif

/**
 @brief （デバッグ用）通信プロトコルの暗号鍵の交換を行うメッセージの暗号化・復号化を行うクラス。
*/
class DebugKeyExchangeCommandEncryptor
{
public:
    DebugKeyExchangeCommandEncryptor() NN_NOEXCEPT;
    explicit DebugKeyExchangeCommandEncryptor(const KeyExchangeCommandConfig::Salt& salt) NN_NOEXCEPT;

    void Encrypt(
        void* outEncrypted, size_t encryptedSize,
        const void* plain, size_t plainSize,
        const void* iv, size_t ivSize) const NN_NOEXCEPT;

    void Decrypt(
        void* outPlain, size_t outPlainSize,
        const void* encrypted, size_t encryptedSize,
        const void* iv, size_t ivSize) const NN_NOEXCEPT;

    void GenerateMac(void* outMac, size_t macSize, const void* data, size_t dataSize) const NN_NOEXCEPT;
    void GenerateMacWithSalt(void* outMac, size_t macSize, const KeyExchangeCommandConfig::Challenge& challenge) const NN_NOEXCEPT;
private:
    KeyExchangeCommandConfig::Salt m_Salt;
};

}}}
