﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace migration { namespace detail {

template <typename ConnectionType, typename ConnectionCreatorType>
struct ConnectionPolicy
{
    typedef ConnectionType Connection;
    typedef ConnectionCreatorType ConnectionCreator;
    typedef typename std::aligned_storage<sizeof(ConnectionCreator), std::alignment_of<ConnectionCreator>::value>::type ConnectionCreatorStorage;
};

}}} // ~namespace nn::migration::detail


#include <nn/migration/idc/migration_SharedBufferConnection.h>
#include <nn/migration/idc/migration_SocketConnection.h>
#include <nn/migration/detail/migration_ConnectionCreator.h>

namespace nn { namespace migration { namespace detail {

typedef ConnectionPolicy<idc::SocketConnection, LdnServerConnectionCreator> LdnServerConnectionPolicy;
typedef ConnectionPolicy<idc::SocketConnection, LdnClientConnectionCreator> LdnClientConnectionPolicy;

}}} // ~namespace nn::migration::detail

