﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         数値が指定された範囲に収まるように変換します。
     *
     * @tparam        T         対象の値の型です。
     *
     * @param[in]     value     変換対象の値です。
     * @param[in]     min       最小値です。
     * @param[in]     max       最大値です。
     *
     * @return        value < min の場合は min, max < value の場合は max,
     *                それ以外の場合は value を返します。
     */
    template <typename T>
    inline T Clamp(T value, T min, T max) NN_NOEXCEPT
    {
        return value < min ? min : (max < value ? max : value);
    }

}}} // end of namespace nn::ldn::detail
