﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         メッセージダイジェストを計算するコールバックです。
     *
     * @param[out]    outHash       メッセージダイジェストの出力先です。
     * @param[out]    outHashSize   メッセージダイジェストの出力サイズです。
     * @param[in]     bufferSize    hash のバッファサイズです。
     * @param[in]     data          入力データです。
     * @param[in]     dataSize      入力データのサイズです。
     */
    typedef void (*CalculateDigest)(
        void* outHash, size_t* outHashSize, size_t bufferSize,
        const void* data, size_t dataSize);

    /**
     * @brief         SHA-256 のメッセージダイジェストを計算します。
     *
     * @param[out]    outHash       メッセージダイジェストの出力先です。
     * @param[out]    outHashSize   メッセージダイジェストの出力サイズです。
     * @param[in]     bufferSize    hash のバッファサイズです。
     * @param[in]     data          入力データです。
     * @param[in]     dataSize      入力データのサイズです。
     */
    void CalculateSha256(
        void* outHash, size_t* outHashSize, size_t bufferSize,
        const void* data, size_t dataSize) NN_NOEXCEPT;

}}} // end of namespace nn::ldn::detail
