﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_Ipv4Address.h>
#include <nn/ldn/ldn_MacAddress.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterfaceProfile.h>

namespace nn { namespace ldn { namespace detail { namespace impl
{
    class TcpIpStackConfigurationImpl
    {
    public:

        TcpIpStackConfigurationImpl() NN_NOEXCEPT;

        ~TcpIpStackConfigurationImpl() NN_NOEXCEPT;

        void Startup(
            Ipv4Address address, Ipv4Address gateway, SubnetMask mask,
            const NetworkInterfaceProfile& profile) NN_NOEXCEPT;

        void Down() NN_NOEXCEPT;

        void AddEntry(Ipv4Address ip, MacAddress mac) NN_NOEXCEPT;

        void RemoveEntry(Ipv4Address ip) NN_NOEXCEPT;

        void ClearEntry() NN_NOEXCEPT;

    private:

        bool m_IsStarted;
    };

}}}} // end of namespace nn::ldn::detail::impl
