﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterfaceProfile.h>
#include <nn/tsc.h>

namespace nn { namespace ldn { namespace detail { namespace impl
{
    // 自分自身は含まないため -1 しています。
    const int ArpEntryCountMax = nn::ldn::NodeCountMax - 1;

    class TcpIpStackConfigurationImpl
    {
    public:

        TcpIpStackConfigurationImpl() NN_NOEXCEPT;

        ~TcpIpStackConfigurationImpl() NN_NOEXCEPT;

        void Startup(
            Ipv4Address address, Ipv4Address gateway, SubnetMask mask,
            const NetworkInterfaceProfile& profile) NN_NOEXCEPT;

        void Down() NN_NOEXCEPT;

        void AddEntry(Ipv4Address ip, MacAddress mac) NN_NOEXCEPT;

        void RemoveEntry(Ipv4Address ip) NN_NOEXCEPT;

        void ClearEntry() NN_NOEXCEPT;

    private:

        std::aligned_storage<sizeof(nn::tsc::Ipv4ConfigContext),
            NN_ALIGNOF(nn::tsc::Ipv4ConfigContext)>::type m_TscContextStorage;
        nn::tsc::Ipv4ConfigContext* m_pTscContext;
        Ipv4Address m_ArpEntries[ArpEntryCountMax];
    };

}}}} // end of namespace nn::ldn::detail::impl
