﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/ldn/ldn_PrivateTypes.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/detail/ldn_Core.h>

namespace nn { namespace ldn { namespace detail
{
    class MonitorService
    {
    public:

        explicit MonitorService(Core* pCore) NN_NOEXCEPT;

        ~MonitorService() NN_NOEXCEPT;

        Result Initialize() NN_NOEXCEPT;

        Result Finalize() NN_NOEXCEPT;

        Result GetState(nn::sf::Out<Bit32> pOutState) const NN_NOEXCEPT;

        Result GetNetworkInfo(nn::sf::Out<NetworkInfo> pOutNetwork) const NN_NOEXCEPT;

        Result GetIpv4Address(
            nn::sf::Out<Ipv4Address> pOutAddress,
            nn::sf::Out<SubnetMask> pOutMask) const NN_NOEXCEPT;

        Result GetDisconnectReason(nn::sf::Out<int16_t> pOutReason) const NN_NOEXCEPT;

        Result GetSecurityParameter(
            nn::sf::Out<SecurityParameter> pOutSecurityParameter) const NN_NOEXCEPT;

        Result GetNetworkConfig(
            nn::sf::Out<NetworkConfig> pOutNetworkConfig) const NN_NOEXCEPT;

    private:

        Core* m_pCore;
    };

}}} // namespace nn::ldn::detail
