﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/ldn/detail/ldn_Config.h>
#include <nn/ldn/detail/Service/ldn_Service.sfdl.h>

#if defined(NN_LDN_BUILD_CONFIG_SF_DFC)
#include <nn/ldn/detail/Service/ldn_CreateServiceByDfc.h>
#else
#include <nn/ldn/detail/Service/ldn_CreateServiceByHipc.h>
#endif

namespace nn { namespace ldn { namespace detail
{
    inline nn::sf::SharedPointer<IUserServiceCreator> CreateUserServiceCreator() NN_NOEXCEPT
    {
        #if defined(NN_LDN_BUILD_CONFIG_SF_DFC)
        auto pAccessor = CreateUserServiceCreatorByDfc();
        #else
        auto pAccessor = CreateUserServiceCreatorByHipc();
        #endif
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

    inline nn::sf::SharedPointer<IMonitorServiceCreator> CreateMonitorServiceCreator() NN_NOEXCEPT
    {
        #if defined(NN_LDN_BUILD_CONFIG_SF_DFC)
        auto pAccessor = CreateMonitorServiceCreatorByDfc();
        #else
        auto pAccessor = CreateMonitorServiceCreatorByHipc();
        #endif
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

    inline nn::sf::SharedPointer<ISystemServiceCreator> CreateSystemServiceCreator() NN_NOEXCEPT
    {
        #if defined(NN_LDN_BUILD_CONFIG_SF_DFC)
                auto pAccessor = CreateSystemServiceCreatorByDfc();
        #else
                auto pAccessor = CreateSystemServiceCreatorByHipc();
        #endif
        NN_SDK_ASSERT(pAccessor);
        return pAccessor;
    }

}}} // namespace nn::ldn::detail
